﻿(function ($) {
    $.widget("a4.a4unsavedChanges", {
        options: {
            elements: ":input:not(input[type=submit]):not(input[type=button])",
            buttons: ":submit,.h-reloadFormButton",
            ignoreDisabledElements: false,
            ignoreHiddenElements: false,
            promptWhenLeavingPage: false,
            promptMessage: "You have unsaved changes in your page"
        },
        _create: function () {
            this._initializeItemsData();

            this._bindEvents();
        },
        _initializeItemsData: function () {
            var self = this;

            this.itemsData = [];

            this.forceChanges = false;

            $(this.options.elements, this.element).each(function () {
                self.itemsData.push({ Hash: self._getInputHash($(this)), OriginalValue: self._getInputValue($(this)), HasChanges: false, Element: $(this) });
            });
        },
        _addItem: function (item) {

        },
        destroy: function () {
            $.Widget.prototype.destroy.call(this);
        },
        _getInputHash: function (input) {
            var inputHash = input.attr("Id") + "_" + input.attr("Name");
            var type = input.attr('type');

            if (type == "checkbox" || type == "radio") {
                inputHash += "_" + input.attr("Value");
            }

            return inputHash;
        },
        _getInputValue: function (input) {
            var val;
            var type = input.attr('type');

            if (input.is('select')) {
                type = 'select';
            }

            switch (type) {
                case 'checkbox':
                case 'radio':
                    val = input.is(':checked');
                    break;
                case 'select':
                    val = '';
                    input.find('option').each(function (o) {
                        var $option = $(this);
                        if ($option.is(':selected')) {
                            val += $option.val();
                        }
                    });
                    break;
                default:
                    val = input.val();
            }

            return val;
        },
        _bindEvents: function () {
            var self = this;

            this.element.on("keyup change", this.options.elements, function (e) {
                var inputHash = self._getInputHash($(this));
                var input = _.find(self.itemsData, function (d) { return d.Hash == inputHash; });

                if (input) {
                    input.HasChanges = input.OriginalValue != self._getInputValue($(this));

                    //Check other changed
                    if (!input.HasChanges) {
                        _.each(self.getChangedItems(), function (i) {
                            i.HasChanges = i.OriginalValue != self._getInputValue(i.Element);
                        });
                    }
                }
                else {
                    self.itemsData.push({ Hash: self._getInputHash($(this)), OriginalValue: self._getInputValue($(this)), HasChanges: true, Element: $(this) });
                }

                self.checkChanges();
            });

            if (this.options.promptWhenLeavingPage) {
                $(document).on("click", self.options.buttons, function (e) {
                    self.hasChanges = false;
                });

                $(window).on("beforeunload", function (e) {
                    if (self.hasChanges) {
                        return self.options.promptMessage;
                    }
                });
            }
        },
        getChangedItems: function () {
            return _.filter(this.itemsData, function (d) { return d.HasChanges; });
        },
        reset: function () {
            this._initializeItemsData();
        },
        checkChanges: function () {
            var changedItems = this.getChangedItems();
            var hasChanges = this.forceChanges || (changedItems && changedItems.length > 0);

            this.element.toggleClass("has-changes", hasChanges);

            this.hasChanges = hasChanges;

            this._trigger("change", null, { hasChanges: hasChanges, changedItems: changedItems });
        },
        change: function () {
            this.forceChanges = true;

            this._trigger("change", null, { hasChanges: true });
        }
    });
}(jQuery));